PROC TABULATE DATA=ghpb09 NOSEPS MISSING ORDER=DATA;
CLASS health_only ENT2 health_type / PRELOADFMT mlf;
LABEL SUBTL_ACT_RTD_SEP_CNT="Total Participants (thousands)"
	  TOT_ACTIVE_PARTCP_CNT="Active Participants (thousands)"
	  TOT_ASSETS_EOY_AMT="Total Assets (millions)"
	  TOT_CONTRIB_AMT="Total Contributions (millions"
	  TOT_DISTRIB_BNFT_AMT="Total Benefits (millions)";
VAR TOT_ACTIVE_PARTCP_CNT TOT_ASSETS_EOY_AMT SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT;
VAR TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT;
TITLE 'Table A1.  Number of Group Health Plans, Total Participants, Active Participants,';
TITLE2 'Assets, Contributions, and Benefits';
TITLE3 'by type of plan and type of insurance, 2009';
TITLE4 'All Plans';
KEYLABEL ALL='Total';
TABLE ALL health_type=' ', 
    N='Number of Plans'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AMT TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT)*F=M13F. / 
    RTS=41 Box='Type of Plan'  MISSTEXT='-';

RUN;

PROC TABULATE DATA=ghpb09 NOSEPS MISSING ORDER=DATA;
where INS3=0;
CLASS health_only ENT2 health_type / PRELOADFMT mlf;
LABEL SUBTL_ACT_RTD_SEP_CNT="Total Participants (thousands)"
	  TOT_ACTIVE_PARTCP_CNT="Active Participants (thousands)"
	  TOT_ASSETS_EOY_AMT="Total Assets (millions)"
	  TOT_CONTRIB_AMT="Total Contributions (millions"
	  TOT_DISTRIB_BNFT_AMT="Total Benefits (millions)";
VAR TOT_ACTIVE_PARTCP_CNT TOT_ASSETS_EOY_AMT SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT;
VAR TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT;
TITLE 'Table A1.  Number of Group Health Plans, Total Participants, Active Participants,';
TITLE2 'Assets, Contributions, and Benefits';
TITLE3 'by type of plan and type of insurance, 2009';
TITLE4 'Self-Insured';
KEYLABEL ALL='Total';
TABLE ALL health_type=' ', 
    N='Number of Plans'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AMT TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT)*F=M13F. / 
    RTS=41 Box='Type of Plan'  MISSTEXT='-';

RUN;

PROC TABULATE DATA=ghpb09 NOSEPS MISSING ORDER=DATA;
where INS3=1;
CLASS health_only ENT2 health_type / PRELOADFMT mlf;
LABEL SUBTL_ACT_RTD_SEP_CNT="Total Participants (thousands)"
	  TOT_ACTIVE_PARTCP_CNT="Active Participants (thousands)"
	  TOT_ASSETS_EOY_AMT="Total Assets (millions)"
	  TOT_CONTRIB_AMT="Total Contributions (millions"
	  TOT_DISTRIB_BNFT_AMT="Total Benefits (millions)";
VAR TOT_ACTIVE_PARTCP_CNT TOT_ASSETS_EOY_AMT SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT;
VAR TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT;
TITLE 'Table A1.  Number of Group Health Plans, Total Participants, Active Participants,';
TITLE2 'Assets, Contributions, and Benefits';
TITLE3 'by type of plan and type of insurance, 2009';
TITLE4 'Mixed-Insured';
KEYLABEL ALL='Total';
TABLE ALL health_type=' ', 
    N='Number of Plans'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AMT TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT)*F=M13F. / 
    RTS=41 Box='Type of Plan'  MISSTEXT='-';

RUN;

PROC TABULATE DATA=ghpb09 NOSEPS MISSING ORDER=DATA;
where INS3=2;
CLASS health_only ENT2 health_type / PRELOADFMT mlf;
LABEL SUBTL_ACT_RTD_SEP_CNT="Total Participants (thousands)"
	  TOT_ACTIVE_PARTCP_CNT="Active Participants (thousands)"
	  TOT_ASSETS_EOY_AMT="Total Assets (millions)"
	  TOT_CONTRIB_AMT="Total Contributions (millions"
	  TOT_DISTRIB_BNFT_AMT="Total Benefits (millions)";
VAR TOT_ACTIVE_PARTCP_CNT TOT_ASSETS_EOY_AMT SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT;
VAR TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT;
TITLE 'Table A1.  Number of Group Health Plans, Total Participants, Active Participants,';
TITLE2 'Assets, Contributions, and Benefits';
TITLE3 'by type of plan and type of insurance, 2009';
TITLE4 'Fully-Insured';
KEYLABEL ALL='Total';
TABLE ALL health_type=' ', 
    N='Number of Plans'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AMT TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT)*F=M13F. / 
    RTS=41 Box='Type of Plan'  MISSTEXT='-';

RUN;
